/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.device;

import cofh.core.network.PacketBase;
import cofh.core.util.core.SideConfig;
import cofh.core.util.core.SlotConfig;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.device.BlockDevice;
import cofh.thermalexpansion.block.device.TileDeviceBase;
import cofh.thermalexpansion.gui.client.device.GuiMobCatcher;
import cofh.thermalexpansion.gui.container.device.ContainerMobCatcher;
import cofh.thermalexpansion.init.TEItems;
import cofh.thermalexpansion.item.ItemMorb;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TileMobCatcher
extends TileDeviceBase
implements ITickable {
    private static final int TYPE = BlockDevice.Type.MOB_CATCHER.getMetadata();
    public static int radius = 5;
    private static final byte MODE_ALL = 0;
    private static final byte MODE_HOSTILE = 1;
    private static final byte MODE_FRIENDLY = 2;
    private static final int TIME_CONSTANT = 60;
    private int inputTracker;
    private int outputTracker;
    public byte mode;
    public byte modeFlag;
    private int offset;

    public static void initialize() {
        TileMobCatcher.SIDE_CONFIGS[TileMobCatcher.TYPE] = new SideConfig();
        TileMobCatcher.SIDE_CONFIGS[TileMobCatcher.TYPE].numConfig = 5;
        TileMobCatcher.SIDE_CONFIGS[TileMobCatcher.TYPE].slotGroups = new int[][]{new int[0], {0}, {1, 2, 3, 4}, {0, 1, 2, 3, 4}, {0, 1, 2, 3, 4}};
        TileMobCatcher.SIDE_CONFIGS[TileMobCatcher.TYPE].sideTypes = new int[]{0, 1, 4, 7, 8};
        TileMobCatcher.SIDE_CONFIGS[TileMobCatcher.TYPE].defaultSides = new byte[]{1, 1, 2, 2, 2, 2};
        TileMobCatcher.SLOT_CONFIGS[TileMobCatcher.TYPE] = new SlotConfig();
        TileMobCatcher.SLOT_CONFIGS[TileMobCatcher.TYPE].allowInsertionSlot = new boolean[]{true, false, false, false, false};
        TileMobCatcher.SLOT_CONFIGS[TileMobCatcher.TYPE].allowExtractionSlot = new boolean[]{false, true, true, true, true};
        GameRegistry.registerTileEntity(TileMobCatcher.class, (String)"thermalexpansion:device_mob_catcher");
        TileMobCatcher.config();
    }

    public static void config() {
        String category = "Device.MobCatcher";
        BlockDevice.enable[TileMobCatcher.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
        String comment = "Adjust this value to change the capture radius for the Creature Encaptulator.";
        radius = ThermalExpansion.CONFIG.getConfiguration().getInt("Radius", category, radius, 2, 16, comment);
    }

    public TileMobCatcher() {
        this.inventory = new ItemStack[5];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.createAllSlots(this.inventory.length);
        this.offset = MathHelper.RANDOM.nextInt(60);
        this.hasAutoInput = true;
        this.hasAutoOutput = true;
        this.enableAutoInput = true;
        this.enableAutoOutput = true;
    }

    public int getType() {
        return TYPE;
    }

    public void func_73660_a() {
        if (!this.timeCheckOffset()) {
            return;
        }
        this.transferOutput();
        this.transferInput();
        boolean curActive = this.isActive;
        if (this.isActive) {
            this.captureMobs();
            if (!this.redstoneControlOrDisable()) {
                this.isActive = false;
            }
        } else if (this.redstoneControlOrDisable()) {
            this.isActive = true;
        }
        this.updateIfChanged(curActive);
    }

    protected void transferInput() {
        if (!this.getTransferIn()) {
            return;
        }
        for (int i = this.inputTracker + 1; i <= this.inputTracker + 6; ++i) {
            int side = i % 6;
            if (!SideConfig.isPrimaryInput((int)this.sideConfig.sideTypes[this.sideCache[side]]) || !this.extractItem(0, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.inputTracker = side;
            break;
        }
    }

    protected void transferOutput() {
        if (!this.getTransferOut()) {
            return;
        }
        boolean foundOutput = false;
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int side = i % 6;
            if (!SideConfig.isPrimaryOutput((int)this.sideConfig.sideTypes[this.sideCache[side]])) continue;
            for (int j = 1; j < 5; ++j) {
                if (!this.transferItem(j, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
                foundOutput = true;
            }
            if (!foundOutput) continue;
            this.outputTracker = side;
            break;
        }
    }

    protected void captureMobs() {
        if (this.inventory[0].func_190926_b() || !this.inventory[0].func_77973_b().equals((Object)TEItems.itemMorb)) {
            return;
        }
        AxisAlignedBB area = new AxisAlignedBB(this.field_174879_c.func_177982_a(-radius, -radius, -radius), this.field_174879_c.func_177982_a(1 + radius, 1 + radius, 1 + radius));
        List mobs = this.field_145850_b.func_175647_a(EntityLiving.class, area, EntitySelectors.field_94557_a);
        mobs.removeIf(mob -> mob instanceof EntityTameable && ((EntityTameable)mob).func_70909_n());
        mobs.removeIf(mob -> !mob.func_184188_bt().isEmpty());
        if (this.mode == 1) {
            mobs.removeIf(mob -> !(mob instanceof IMob));
        } else if (this.mode == 2) {
            mobs.removeIf(mob -> mob instanceof IMob);
        }
        if (mobs.isEmpty()) {
            return;
        }
        int type = ItemHelper.getItemDamage((ItemStack)this.inventory[0]);
        for (int i = 1; i < 5; ++i) {
            if (this.inventory[i].func_190926_b()) {
                this.capture(mobs, i, type);
            }
            if (this.inventory[0].func_190926_b()) break;
        }
    }

    protected void capture(List<EntityLiving> mobs, int slot, int type) {
        Iterator<EntityLiving> iterator = mobs.iterator();
        while (iterator.hasNext()) {
            EntityLiving mob = iterator.next();
            if (!ItemMorb.validMobs.contains(EntityList.func_191301_a((Entity)mob).toString())) continue;
            this.inventory[slot] = ItemMorb.getMorb(type, mob.serializeNBT());
            this.inventory[0].func_190917_f(-1);
            BlockPos mobPos = mob.func_180425_c();
            ((WorldServer)this.field_145850_b).func_175739_a(EnumParticleTypes.CLOUD, (double)mobPos.func_177958_n() + 0.5, (double)mobPos.func_177956_o() + 0.2, (double)mobPos.func_177952_p() + 0.5, 2, 0.0, 0.0, 0.0, 0.0, new int[]{0});
            mob.func_70106_y();
            iterator.remove();
            return;
        }
    }

    protected boolean timeCheckOffset() {
        return (this.field_145850_b.func_82737_E() + (long)this.offset) % 60L == 0L;
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiMobCatcher(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerMobCatcher(inventory, (TileEntity)this);
    }

    public void toggleMode(boolean decrement) {
        if (decrement) {
            this.mode = (byte)(this.mode - 1);
            if (this.mode < 0) {
                this.mode = (byte)2;
            }
        } else {
            this.mode = (byte)(this.mode + 1);
            if (this.mode > 2) {
                this.mode = 0;
            }
        }
        this.sendModePacket();
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inputTracker = nbt.func_74762_e("TrackIn");
        this.outputTracker = nbt.func_74762_e("TrackOut");
        this.mode = nbt.func_74771_c("Mode");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TrackIn", this.inputTracker);
        nbt.func_74768_a("TrackOut", this.outputTracker);
        nbt.func_74774_a("Mode", this.mode);
        return nbt;
    }

    public PacketBase getModePacket() {
        PacketBase payload = super.getModePacket();
        payload.addByte(this.mode);
        return payload;
    }

    protected void handleModePacket(PacketBase payload) {
        super.handleModePacket(payload);
        this.modeFlag = this.mode = payload.getByte();
        this.callNeighborTileChange();
    }

    public PacketBase getGuiPacket() {
        PacketBase payload = super.getGuiPacket();
        payload.addByte(this.mode);
        return payload;
    }

    protected void handleGuiPacket(PacketBase payload) {
        super.handleGuiPacket(payload);
        this.modeFlag = this.mode = payload.getByte();
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return stack.func_77973_b().equals((Object)TEItems.itemMorb);
    }
}

